/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.services;

import appeng.blockentity.spatial.SpatialAnchorBlockEntity;
import appeng.server.services.ChunkLoadState;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;

public class ChunkLoadingService {
    private static final ChunkLoadingService INSTANCE = new ChunkLoadingService();
    private boolean running = true;

    public void onServerAboutToStart() {
        this.running = true;
    }

    public void onServerStopping() {
        this.running = false;
    }

    public static ChunkLoadingService getInstance() {
        return INSTANCE;
    }

    public void validateTickets(class_3218 level) {
        ChunkLoadState state = ChunkLoadState.get(level);
        for (Map.Entry<class_2338, LongSet> entry : state.getAllBlocks().entrySet()) {
            class_2338 blockPos = entry.getKey();
            LongSet chunks = entry.getValue();
            class_2586 blockEntity = level.method_8321(blockPos);
            if (blockEntity instanceof SpatialAnchorBlockEntity) {
                SpatialAnchorBlockEntity anchor = (SpatialAnchorBlockEntity)blockEntity;
                LongIterator longIterator = chunks.iterator();
                while (longIterator.hasNext()) {
                    long chunk = (Long)longIterator.next();
                    anchor.registerChunk(new class_1923(chunk));
                }
                continue;
            }
            state.releaseAll(blockPos);
        }
    }

    public boolean forceChunk(class_3218 level, class_2338 owner, class_1923 position) {
        if (this.running) {
            ChunkLoadState.get(level).forceChunk(position, owner);
            return true;
        }
        return false;
    }

    public boolean releaseChunk(class_3218 level, class_2338 owner, class_1923 position) {
        if (this.running) {
            ChunkLoadState.get(level).releaseChunk(position, owner);
            return true;
        }
        return false;
    }

    public boolean isChunkForced(class_3218 level, int chunkX, int chunkZ) {
        return ChunkLoadState.get(level).isForceLoaded(chunkX, chunkZ);
    }
}

